[//lasso
	// must be authorized for file tags and os_process
	auth_admin;

	// make sure shell.lasso is loaded from lassostartup

	// load required tags
	library('tags/array_unique.inc');
	library('tags/asset_manager.inc');
	library('tags/cache_assets.inc');
	library('tags/compress_gzip.inc');
	library('tags/server_webroot.inc');
	library('tags/url_normalize.inc');

	// initialize the asset manager	
	asset_manager->options(
		-usecache=true,
		-minify=true,
		-compress=false,
		-refresh=true,
		-paths=map(
			'yui'=server_webroot + '/assetmgr/yuicompressor.jar',
			'scriptcache'='/assetmgr/scripts/cache/',
			'stylecache'='/assetmgr/styles/cache/',
			'scriptbase'='/assetmgr/scripts/base/',
			'stylebase'='/assetmgr/styles/base/'
		),
		-subdomains=(: '/[^"]+?' = 'http://local.dev\\1')	
	);
	
	// add some assets
	asset_manager->add('scripts/jquery.corner.js');
	asset_manager->add('scripts/global.js');
	asset_manager->add('styles/global.css');
]
<html>
	<head>
		<title>Asset Manager Example</title>
	</head>
	<body>
		<h1>Hello, world.</h1>
	</body>
</html>
